import tkinter
from tkinter import messagebox, filedialog
from time import sleep, time
from random import choice

class Game:
    canvas = None

    def __init__(self):
        self.root = Match.root = tkinter.Tk()
        self.root.title('Dáma')
        self.root.resizable(width=False, height=False)
        self.root.iconbitmap('icon.ico')        
        self.root.attributes('-topmost', True)
        self.menu()

    def menu(self):
        '''nastavenie canvasu, pociatocneho label-u a buttonov'''
        self.canvas = Match.canvas = Opponent.canvas = Player.canvas = Checker.canvas = tkinter.Canvas(
            width=200, height=100)
        self.label = tkinter.Label(text='Vitaj v hre Dáma', font='Arial 20',
         width=30, pady=15)
        self.label.pack()
        self.newg_btn = tkinter.Button(text='Nová hra',
         font='Arial 20', width=30, command=self.new_game)
        self.loadg_btn = tkinter.Button(text='Načítaj hru',
         font='Arial 20', width=30, command=self.load_game)
        self.newg_btn.pack()
        self.loadg_btn.pack()
        self.canvas.pack()
        self.canvas.mainloop()

    def new_game(self):   
        self.label.config(text='Vyber si stranu')
        self.newg_btn.config(text='Biely', command=lambda: self.start_game('white', 'black'))
        self.loadg_btn.config(text='Čierny', command=lambda: self.start_game('black', 'white'))

    def start_game(self, color1, color2, checkers=None):
        '''realne sa hra zapne az tu
        znicia sa buttony, label a pokracujeme v triede Match'''
        self.newg_btn.destroy()
        self.loadg_btn.destroy()
        self.label.destroy()
        self.color1, self.color2 = color1, color2
        self.root.protocol('WM_DELETE_WINDOW', lambda: self.save_game_prompt(True))        
        self.create_dropdown_menu()
        Match(color1, color2, checkers, self)

    def load_game(self):
        file = filedialog.askopenfile(mode='r', filetypes=[('Textové Súbory', '*.txt')])
        if file is None: return

        if file.readline() != '[SAVED_GAME]\n':
            messagebox.showerror(title='Chyba', message='Súbor neobsahuje uloženú hru')
        else:
            color1 = file.readline().split(' = ')[1].rstrip()
            color2 = file.readline().split(' = ')[1].rstrip()            
            self.loadg_btn.destroy()
            self.newg_btn.destroy()
            self.label.destroy()
            self.start_game(color1, color2, [row.split() for row in file])

    def save_game_prompt(self, exiting):
        result = messagebox.askyesno(title='Dáma',
         message='Chcete si uložiť hru?')

        if result:
            self.saving_game(exiting)
        else:
            if exiting:
                self.client_exit() 

    def saving_game(self, exiting):
        if exiting:
            self.create_save()
            self.client_exit()
        else:
            self.create_save()

    def create_save(self):
        file_path = filedialog.asksaveasfile(mode='w', filetypes=[('Textové Súbory', '*.txt')], defaultextension=[('Textové Súbory', '*.txt')])

        print('[SAVED_GAME]', file=file_path)
        print(f'color1 = {self.color1}', file=file_path)
        print(f'color2 = {self.color2}', file=file_path)
        for row in self.checkers:
            aux = []
            for tile in row:
                char = '.'
                if isinstance(tile, Checker):
                    char = tile.side
                aux.append(char)
            aux = ' '.join(aux)
            print(f'{aux}', file=file_path)     

    def create_dropdown_menu(self):
        menu = tkinter.Menu(self.root)
        self.root.config(menu=menu)
        file = tkinter.Menu(menu, tearoff=False)
        file.add_command(label='Ulož hru', command=self.create_save)
        file.add_command(label='Načítaj hru', command=self.load_game)
        file.add_command(label='Restart', command=lambda: self.restart(True))
        menu.add_cascade(label='Game', menu=file)

    def restart(self, prompt=False):
        if prompt:
            self.save_game_prompt(False)
        Match(self.color1, self.color2, game=self)

    def client_exit(self):         
        self.root.destroy()                
                

class Match:
    bSize = 8
    def __init__(self, colorP=None, colorE=None, file=None, game=None): 
        '''nastavenie dolezitej premennej checkers, vytvorenie dosky a polozenie figúr na dosku'''       
        self.game = game
        self.canvas.config(width=720, height=720)
        self.create_board()        
        self.startTimer = time()
        override_next = False
        if not file:
            aux = [['.' for j in range(self.bSize)] for i in range(self.bSize)].copy()
        else:
            aux = file
            override_next = True
            
        self.checkers = Game.checkers = Player.checkers = \
        Opponent.checkers = Checker.checkers = aux

        if not file:
            for j in range(4):
                self.checkers[0][j*2 + 1] = 'o'
                self.checkers[1][j*2] = 'o'
                self.checkers[2][j*2 + 1] = 'o'
                self.checkers[5][j*2] = 'p'
                self.checkers[6][j*2 + 1] = 'p'
                self.checkers[7][j*2] = 'p'  
       
        self.put_checkers(colorP, colorE)
        self.player = Player(self)
        self.opponent = Opponent(self)
        if not override_next:
            if colorP == 'white':
                self.next_turn('p')
            else:
                self.next_turn('b')
        else:
            self.next_turn('p')

    def next_turn(self, who):
        if not self.end():
            if who == 'p':
                self.player.turn()
            else:                
                self.opponent.turn()
        else:
            self.announce_end_of_game()

    def announce_end_of_game(self):
        end = time()
        option = messagebox.askyesnocancel(title='Hra skončila',
        message=f'Víťazstvo berie {self.whomst} (hra trvala {int(end - self.startTimer)} sekúnd), chcete reštartovať hru?')
        if option:
            self.game.restart() #...
        elif option == False:
            quit()
        else: pass
        

    def end(self):
        if self.win():
            self.whomst = 'hráč'
            return True
        elif self.loss():
            self.whomst = 'počítač'
            return True
        return False

    def win(self):
        for row in self.checkers:
            for tile in row:
                if isinstance(tile, Checker) and tile.side == 'o':
                    return False
        return True

    def loss(self):
        for row in self.checkers:
            for tile in row:
                if isinstance(tile, Checker) and tile.side == 'p':
                    return False
        return True    

    def create_board(self):
        a = int(self.canvas['width'])/self.bSize
        for i in range(self.bSize):
            for j in range(self.bSize):
                color = 'navajowhite'
                if (i+j) % 2:
                    color = 'sienna'
                self.canvas.create_rectangle(j*a,
                 i*a, j*a+a, i*a+a, fill=color)            
    
    def put_checkers(self, colorP, colorE):
        self.oppTroops = []
        for i in range(len(self.checkers)):
            for j in range(len(self.checkers[i])):
                if self.checkers[i][j] == 'p':
                    self.checkers[i][j] = Checker(i, j, ('p', 'o'), colorP)
                elif self.checkers[i][j] == 'o':
                    self.checkers[i][j] = Checker(i, j, ('o', 'p'), colorE)
                    self.oppTroops.append(self.checkers[i][j])

    def delete_checker(self, i, j):
        self.checkers[i][j].die()
        self.checkers[i][j] = '.'


class Player:
    def __init__(self, Match):
        self.Match = Match
        self.activeChecker = None
        self.activeJumped = False

    def turn(self):
        self.canvas.bind('<ButtonPress-1>', self.selector)

    def end_turn(self):
        self.canvas.unbind('<ButtonPress-1>')

    def selector(self, event):
        '''bud si vyberam checker alebo s vybranym uz hybem'''
        a = int(self.canvas['width']) // Match.bSize
        r, c = int(event.y) // a, int(event.x) // a
        tile = self.checkers[r][c]        
        if isinstance(tile, Checker):
            if tile.side == 'p':   
                if not self.activeJumped:
                    if self.activeChecker:
                        self.deselect_active()
                    self.activeChecker = tile
                    self.activeChecker.highlight()
            else:
                self.deselect_active()
        else:
            if self.activeChecker:                
                moves = self.activeChecker.moveable()
                if (r, c) in moves[1]: # in jumps  
                    i, j = self.activeChecker.i, self.activeChecker.j
                    self.Match.delete_checker((r+i) // 2, (c+j) // 2)
                    self.activeChecker.move(r, c)
                    self.activeJumped = True
                    if not self.activeChecker.moveable()[1]:
                        self.deselect_active()
                        self.Match.next_turn('o')    
                elif (r, c) in moves[0]:    # in moves  
                    if not self.activeJumped:                         
                        self.activeChecker.move(r, c)
                        self.deselect_active()
                        self.Match.next_turn('o')        
                else:
                    self.deselect_active()

    def deselect_active(self):
        self.activeChecker.unhighlight()
        self.activeChecker = None
        self.activeJumped = False

class Checker:
    def __init__(self, i, j, sides, color):
        self.i, self.j = i, j
        self.side, self.oppSide = sides 
        self.king = False
        self.color = color
        self.create(i, j, color)

    def coords(self, i, j):
        a = int(self.canvas['width']) // Match.bSize
        s = a/2 - 10
        y, x = i*a + a/2, j*a + a/2
        return x, y, s

    def create(self, i, j, color):  
        x, y, s = self.coords(i, j)
        self.id = self.canvas.create_oval(x-s, y-s, x+s, y+s, fill=color)   

    def coronation(self):
        self.king = True
        color = 'black'
        if self.color == 'black':
            color = 'white'
        self.crown = self.canvas.create_text(self.coords(self.i, self.j)[:2],
         text='♔', font='Arial 30', fill=color)
    
    def move(self, i, j):
        self.checkers[self.i][self.j] = '.' 
        self.checkers[i][j] = self
        self.i, self.j = i, j
        if not self.king:
            if self.side == 'p' and i == 0:
                self.coronation()
            elif self.side == 'o' and i == Match.bSize - 1:
                self.coronation()

        x, y, s = self.coords(i, j)
        self.canvas.coords(self.id, x-s, y-s, x+s, y+s)
        if self.king:
            self.canvas.coords(self.crown, x, y)

    def highlight(self):
        self.canvas.itemconfig(self.id, width=4, outline='red')

    def unhighlight(self):
        self.canvas.itemconfig(self.id, width=1, outline='black')

    def can_move(self, i, j):
        return 0<=i<Match.bSize and 0<=j<Match.bSize

    def die(self):
        self.canvas.delete(self.id)
        if self.king:
            self.canvas.delete(self.crown)

    def moveable(self, i=None, j=None): 
        if not i and not j:
            i, j = self.i, self.j
        moves, jumps = [], []
        if self.side == 'p':
            rc = ((-1, -1), (-1, 1))
        else:
            rc = ((1, -1), (1, 1))
        if self.king:
            if self.side == 'p':
                rc += (1, -1), (1, 1),
            else:
                rc += (-1, -1), (-1, 1),

        for r, c in rc:
            if self.can_move(i+r, j+c):
                if self.checkers[i+r][j+c] is '.':
                   moves += [(i+r, j+c)]
                elif self.checkers[i+r][j+c].side == self.oppSide:
                    if self.can_move(i+2*r, j+2*c):
                        if self.checkers[i+2*r][j+2*c] == '.':
                            jumps += [(i+2*r, j+2*c)]
        return moves, jumps
        
    def is_checker(self, r, c):
        return isinstance(self.checkers[r][c], Checker)

    def best_route(self):
        '''vyhodnot najlepsiu cestu'''
        def endanger_other(i, j):
            rating = 0
            for dr, dc in ((-1, -1), (-1, 1), (1, 1), (1, -1)):
                try:
                    if self.is_checker(i+dr, j+dc) and self.checkers[i+dr][j+dc].side == self.side:
                        if self.is_checker(i+2*dr, j+2*dc) and self.checkers[i+2*dr][j+2*dc].side == self.oppSide:
                            if dr == -1:
                                if self.checkers[i+2*dr][j+2*dc].king:
                                    rating -= 1
                                else: continue
                            rating -= 1
                except IndexError: pass
            return rating

        def endanger_self(i, j):
            oi, oj = self.i, self.j #original
            drc = [(-1, -1), (-1, 1), (1, 1), (1, -1)]
            if (i-oi, j-oj) in drc:
                drc.remove( (-(i-oi), -(j-oj) ) )

            rating = 0
            for dr, dc in drc:
                try:
                    if self.is_checker(i+dr, j+dc) and self.checkers[i+dr][j+dc].side == self.oppSide:
                        if (i-dr) != oi and (j-dc) != oj:
                            if not self.is_checker(i-dr, j-dc):
                                if dr == -1:
                                    if self.checkers[i+dr][j+dc].king:    
                                        rating -= 1
                                    else: continue
                                rating -= 1
                        else:
                            rating -= 1
                except IndexError: pass
            return rating

        def defend_other(nr, nc):
            return abs(endanger_other(nr, nr))*2  

        def defend_self(nr, nc):
            drc = [(-1, -1), (-1, 1), (1, 1), (1, -1)]
            rating = 0
            i, j = nr, nc
            for dr, dc in drc:
                try:
                    if self.is_checker(i+dr, j+dc) and self.checkers[i+dr][j+dc].side == self.oppSide:
                        if not self.is_checker(i-dr, j-dc):
                            if dr == -1:
                                if self.checkers[i+dr][j+dc].king:    
                                    rating += 1
                                else: continue
                            rating += 1
                except IndexError: pass            
            return rating

        def become_king(ni):
            if ni == Match.bSize - 1 and not self.king:
                return 1
            return 0

        def rec_jumps(i, j, path):
            jumps = self.moveable(i, j)[1]
            for p in path:
                if p in jumps:
                    jumps.remove(p)
            if jumps:
                for nr, nc in jumps:
                    if (nr, nc) not in path:
                        rec_jumps(nr, nc, path + [(nr, nc)])
            else:
                paths.append(path)


        moves, jumps = self.moveable()
        best = {'value': None, 'who': (self.i, self.j), 'where': None}
        
        for nr, nc in moves:
            value = 1 + endanger_other(self.i, self.j) + endanger_self(nr, nc) \
              + become_king(nr) + defend_other(nr, nc) + defend_self(self.i, self.j)
            if not best['value'] or value > best['value']:
                best['value'] = value
                best['where'] = nr, nc
                best['mJumps'] = []            

        for nr, nc in jumps:
            paths, mJumps = [], []                        
            rec_jumps(nr, nc, [(nr, nc)])
            for path in paths:
                value = len(paths)*3 + endanger_other(self.i, self.j) + endanger_self(*path[-1]) \
                 + defend_other(*path[-1]) + become_king(path[-1][0]) + defend_self(self.i, self.j)
                if not mJumps or value > mJumps[0]:
                    mJumps = value, path
            
            if not best['value'] or value > best['value']:
                best['value'] = value
                best['where'] = nr, nc
                best['mJumps'] = mJumps[1]
        return best


class Opponent: 
    def __init__(self, Match):
        self.Match = Match

    def turn(self):
        '''pre kazdy checker najdi najlepsiu cestu a potom z tych najlepsich vyber najlepsiu celkovu'''
        bestRoutes = []
        for row in self.checkers:
            for tile in row:
                if isinstance(tile, Checker):
                    if tile.side == 'o':                        
                        best = tile.best_route()
                        if best['where']:
                            if not bestRoutes or best['value'] > bestRoutes[0]['value']:
                                bestRoutes = [best]
                            elif bestRoutes[0]['value'] == best['value']:
                                bestRoutes.append(best)
        if not bestRoutes: # ked sa vobec nema kam pohnut
            self.Match.whomst = 'p'
            self.Match.announce_end_of_game()

        best = choice(bestRoutes)
        checker = self.checkers[best['who'][0]][best['who'][1]]
        if not best['mJumps']:
            checker.highlight()
            self.canvas.update()
            sleep(0.3)
            self.canvas.update()
            checker.move(*best['where'])
            sleep(0.2)
            self.canvas.update()
            checker.unhighlight()
        else:
            checker.highlight()  
            self.canvas.update()              
            sleep(0.3)          
            self.canvas.update()
            for nr, nc in best['mJumps']:   
                i, j = checker.i, checker.j
                checker.move(nr, nc)
                self.Match.delete_checker((nr+i) // 2, (nc+j) // 2)  
                sleep(0.2)
                self.canvas.update()
            checker.unhighlight()
        self.Match.next_turn('p')               
      
Game()